#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INFLL = (1LL<<60);

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<ll> x(n), h(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> h[i];

    vector<int> ids(n);
    iota(ids.begin(), ids.end(), 0);
    sort(ids.begin(), ids.end(), [&](int a, int b){
        return x[a] < x[b];
    });

    vector<ll> uniq_h = h;
    sort(uniq_h.begin(), uniq_h.end());
    uniq_h.erase(unique(uniq_h.begin(), uniq_h.end()), uniq_h.end());
    int m = uniq_h.size();

    vector<int> h_idx(n);
    for (int i = 0; i < n; ++i)
        h_idx[i] = lower_bound(uniq_h.begin(), uniq_h.end(), h[i]) - uniq_h.begin();

    vector<vector<int>> add_pairs(m+1), rem_pairs(m+1);

    struct PairInfo {
        int L, R;
        ll A, B;
        ll y2;
    };

    vector<PairInfo> pairs;
    pairs.reserve(max(0, n-1));

    for (int t = 0; t + 1 < n; ++t) {
        int L = ids[t];
        int R = ids[t+1];

        ll A = x[L] + h[L];
        ll B = x[R] - h[R];
        ll y2 = A - B;

        ll add_h = y2 / 2 + ((y2 % 2 != 0 && y2 > 0) ? 1 : 0);
        ll rem_h = max(h[L], h[R]) + 1;

        int add_idx = lower_bound(uniq_h.begin(), uniq_h.end(), add_h) - uniq_h.begin();
        int rem_idx = lower_bound(uniq_h.begin(), uniq_h.end(), rem_h) - uniq_h.begin();

        int pidx = pairs.size();
        pairs.push_back({L, R, A, B, y2});

        if (add_idx < rem_idx) {
            add_pairs[add_idx].push_back(pidx);
            rem_pairs[rem_idx].push_back(pidx);
        }
    }

    vector<vector<int>> rem_pole(m+1);
    for (int i = 0; i < n; ++i)
        if (h_idx[i] + 1 <= m)
            rem_pole[h_idx[i] + 1].push_back(i);

    vector<vector<int>> poles_of_height(m);
    for (int i = 0; i < n; ++i)
        poles_of_height[h_idx[i]].push_back(i);

    set<pair<ll,int>> setX;
    for (int i = 0; i < n; ++i)
        setX.insert({x[i], i});

    set<pair<ll,int>> setA, setB;
    vector<ll> ans(n, -1);

    for (int k = 0; k < m; ++k) {
        ll curh = uniq_h[k];

        for (int pid : rem_pole[k])
            setX.erase({x[pid], pid});

        for (int pidx : add_pairs[k]) {
            setA.insert({pairs[pidx].A, pidx});
            setB.insert({pairs[pidx].B, pidx});
        }

        for (int pidx : rem_pairs[k]) {
            setA.erase({pairs[pidx].A, pidx});
            setB.erase({pairs[pidx].B, pidx});
        }

        for (int pid : poles_of_height[k]) {
            ll best = INFLL;
            ll xi = x[pid];
            ll hi = h[pid];

            auto it = setX.lower_bound({xi, -1});
            auto r = it;
            while (r != setX.end() && r->second == pid) ++r;
            if (r != setX.end())
                best = min(best, llabs(r->first - xi));

            if (it != setX.begin()) {
                auto l = prev(it);
                if (l->second == pid && l != setX.begin())
                    l = prev(l);
                if (l->second != pid)
                    best = min(best, llabs(l->first - xi));
            }

            ll keyA = xi + hi;
            it = setA.lower_bound({keyA, -1});
            for (int s = 0; s < 2 && it != setA.end(); ++s, ++it) {
                ll xc = it->first - hi;
                if (xc != xi)
                    best = min(best, llabs(xc - xi));
            }
            if (it != setA.begin()) {
                auto it2 = prev(it);
                for (int s = 0; s < 2; ++s) {
                    ll xc = it2->first - hi;
                    if (xc != xi)
                        best = min(best, llabs(xc - xi));
                    if (it2 == setA.begin()) break;
                    --it2;
                }
            }

            ll keyB = xi - hi;
            it = setB.lower_bound({keyB, -1});
            for (int s = 0; s < 2 && it != setB.end(); ++s, ++it) {
                ll xc = it->first + hi;
                if (xc != xi)
                    best = min(best, llabs(xc - xi));
            }
            if (it != setB.begin()) {
                auto it2 = prev(it);
                for (int s = 0; s < 2; ++s) {
                    ll xc = it2->first + hi;
                    if (xc != xi)
                        best = min(best, llabs(xc - xi));
                    if (it2 == setB.begin()) break;
                    --it2;
                }
            }

            if (best != INFLL) ans[pid] = best;
        }
    }

    for (int i = 0; i < n; ++i)
        cout << ans[i] << '\n';

    return 0;
}